import static com.xebialabs.restito.semantics.Action.contentType;
import static com.xebialabs.restito.semantics.Action.custom;
import static com.xebialabs.restito.semantics.Action.header;
import static com.xebialabs.restito.semantics.Action.status;
import static com.xebialabs.restito.semantics.Action.stringContent;

import java.io.IOException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.xebialabs.restito.semantics.Action;
import com.xebialabs.restito.semantics.Function;
import com.xebialabs.restito.server.StubServer;

public abstract class AbstractMock {
    public String loadTemplate(String fileName) {
        URL resource = Resources.getResource(fileName);
        String fileContent = null;

        try {
            fileContent = Resources.toString(resource, Charsets.UTF_8);
        } catch (IOException e) {
            System.out.println(e);
        }
        return fileContent;
    }

    public abstract void run(StubServer server);

    public Action[] generateResponse(HttpStatus httpStatus, String content) {
        Action[] actions = new Action[8];

        ArrayList<Action> arrayList = new ArrayList<Action>(commonResponseActions());
        arrayList.add(status(httpStatus));
        arrayList.add(stringContent(content));

        return arrayList.toArray(actions);
    }

    public Action[] generateResponse(HttpStatus httpStatus, Function<Response, Response> content) {
        Action[] actions = new Action[8];

        ArrayList<Action> arrayList = new ArrayList<Action>(commonResponseActions());
        arrayList.add(status(httpStatus));
        arrayList.add(custom(content));

        return arrayList.toArray(actions);
    }

    private ArrayList<Action> commonResponseActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(header("Access-Control-Allow-Origin", "*"));
        arrayList.add(header("Access-Control-Allow-Headers", "authorization, content-type"));
        arrayList.add(header("Access-Control-Allow-Methods", "GET, POST, PUT, OPTIONS, DELETE"));
        arrayList.add(header("Cache-Control", "no-cache, no-store, must-revalidate"));
        arrayList.add(header("Pragma", "no-cache"));
        arrayList.add(contentType("application/json"));

        return arrayList;
    }

    public String matchingRegex(String srcString, String regex) {
        String matchingString = null;

        Pattern pattern = Pattern.compile(regex);
        Matcher patternMatcher = pattern.matcher(srcString);
        if (patternMatcher.find()) {
            matchingString = patternMatcher.group(1);
        }

        return matchingString;
    }

    public String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        return formatter.format(date);
    }

    public Date parse(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        return formatter.parse(dateString, new ParsePosition(0));
    }
}
